$set $year           =  98 

#
# comment lines are indicated by an "#". They are allowed after the entries or at the beginning of the lines
#
# paragraphs of the control file:
#
# [output_interval]
# [coordinates]            (geogr. coordinates)
# [elevation_model]        (name of the elevation model)
# [zonengrid]              (name of the zone grid)
# [standardgrids]          (name of other static grids like slope angle, slope aspect, topogr. factor)
# [variable_grids]         (names of albedo and soil storage - used by more than one modules)
# [model_time]             (start end end-dates of model time)
# [meteo_data_count]       (number of mete data to interpolate)
# [meteo_names]            (names of meteo data to interpolate - each name is later the headline of a paragraph for interpolation
# [precipitation_correction] (paragraph for parameters of the prec.-correction)
# [radiation_correction]   (paragraph with parameters for radiation correction)
# [evapotranspiration]     (paragraph with parameters for evapotranspiration)
# [snow_model]             (paragraph with parameters for the snow model)
# [interzeption_model]     (paragraph with parameters for the interzeption modell)
# [infiltration_model]     (paragraph with parameters for the infiltration modell)
# [soil_model]             (paragraph with parameters for the soilmodel)
# [unsatzon_model]         (paragraph with parameters for the unsaturated zone model)
# [irrigation]             (paragraph with parameters for irrigation model)
# [groundwater_flow]       (paragraph with parameters for groundwater model)
# [routing_model]          (paragraph with Parametern for discharge routing)
# [landuse_table]          (paragraph with land use (vegetation) parameters)
# [soil_table]             (paragraph with soil properties)
# [substance_transport]    (paragraph with tracer properties)
#
#
# symbol definitions begin with the set command:
# max. 200 symbols can be defined

$set $outpath        = c:\_demo_\_web_\output_vcz\
$set $inpath         = c:\_demo_\_web_\input\
$set $exchngpath     = c:\_demo_\_web_\exchange\
$set $time           = 60.0

$set $grid           =  r500
$set $stack          =  r500
$set $suffix         =  grd
$set $code           =  s

# variables for standardgrids
# first section: grids, which differ for different subdivisions of the basin
$set $zone_grid             =  $grid//.use
$set $subcatchments         =  $grid//.e10
$set $flow_time_grid        =  $grid//.fzs
$set $river_links_grid      =  $grid//.lnk
$set $regio_grid            =  $grid//.reg

#second section: grids, which doesn't depend on subdivision (only pixel-values are of interest)
$set $elevation_model       =  $grid//.dhm
$set $RelCellArea_grid      =  $grid//.rca
$set $CellSizeX_grid        =  $grid//.csx
$set $CellSizeY_grid        =  $grid//.csy
$set $slope_grid            =  $grid//.slp
$set $aspect_grid           =  $grid//.exp
$set $land_use_grid         =  $grid//.use
$set $ice_firn_grid         =  $grid//.ice
$set $field_capacity_grid   =  $grid//.nfk
$set $ATBgrid               =  $grid//.atb
$set $hydr_cond_grid        =  $grid//.k
$set $soil_types            =  $grid//.art
$set $sky_view_factor_grid  =  $grid//.hor
$set $drain_depth_grid      =  $grid//.drn
$set $drain_distance_grid   =  $grid//.dis
$set $irrigationcodes       =  $grid//.irr
$set $max_pond_grid         =  $grid//.pnd
$set $clay_depth_grid       =  $grid//.cly
$set $river_depth_grid      =  $grid//.dep
$set $river_width_grid      =  $grid//.wit
$set $tracer_1              =  $grid//.c1
$set $tracer_2              =  $grid//.c2
$set $tracer_3              =  $grid//.c3
$set $tracer_4              =  $grid//.c4
$set $tracer_5              =  $grid//.c5
$set $tracer_6              =  $grid//.c6
$set $tracer_7              =  $grid//.c7
$set $tracer_8              =  $grid//.c8
$set $tracer_9              =  $grid//.c9
$set $kolmationsgrid        =  $grid//.kol
$set $gw_kx_1_grid          =  $grid//.kx1
$set $gw_kx_2_grid          =  $grid//.kx2
$set $gw_kx_3_grid          =  $grid//.kx3
$set $gw_ky_1_grid          =  $grid//.ky1
$set $gw_ky_2_grid          =  $grid//.ky2
$set $gw_ky_3_grid          =  $grid//.ky3
$set $gw_bound_h_1_grid     =  $grid//.bh1
$set $gw_bound_h_2_grid     =  $grid//.bh2
$set $gw_bound_h_3_grid     =  $grid//.bh3
$set $gw_bound_q_1_grid     =  $grid//.bq1
$set $gw_bound_q_2_grid     =  $grid//.bq2
$set $gw_bound_q_3_grid     =  $grid//.bq3
$set $aquiferthick1         =  $grid//.aq1
$set $aquiferthick2         =  $grid//.aq2
$set $aquiferthick3         =  $grid//.aq3
$set $gw_storage_coeff_1    =  $grid//.s01
$set $gw_storage_coeff_2    =  $grid//.s02
$set $gw_storage_coeff_3    =  $grid//.s03
$set $gw_kolmation_1        =  $grid//.gk1
$set $gw_kolmation_2        =  $grid//.gk2
$set $gw_kolmation_3        =  $grid//.gk3

# grids for surface hydrolgy modules
$set $albedo               =  albe//$grid//.//$suffix
$set $soilstoragegrid      =  sb__//$grid//.//$suffix
$set $throughfall          =  qi__//$grid//.//$suffix
$set $snowcover_outflow    =  qsno//$grid//.//$suffix
$set $melt_from_snowcover  =  qsme//$grid//.//$suffix
$set $days_snow            =  sday//$grid//.//$suffix
$set $snow_age             =  sage//$grid//.//$suffix
$set $snow_rate            =  snow//$grid//.//$suffix
$set $rain_rate            =  rain//$grid//.//$suffix
$set $firn_melt            =  qfir//$grid//.//$suffix
$set $ice_melt             =  qice//$grid//.//$suffix
$set $preci_grid           =  prec//$grid//.//$suffix
$set $irrig_grid           =  irri//$grid//.//$suffix
$set $tempegrid            =  temp//$grid//.//$suffix
$set $windgrid             =  wind//$grid//.//$suffix
$set $sunshinegrid         =  ssd_//$grid//.//$suffix
$set $radiationgrid        =  rad_//$grid//.//$suffix
$set $humiditygrid         =  humi//$grid//.//$suffix
$set $vaporgrid            =  vapo//$grid//.//$suffix
$set $ETPgrid              =  etp_//$grid//.//$suffix
$set $EIPgrid              =  eip_//$grid//.//$suffix
$set $ETRgrid              =  etr_//$grid//.//$suffix
$set $EVAPgrid             =  evap//$grid//.//$suffix
$set $EVARgrid             =  evar//$grid//.//$suffix
$set $ETRSgrid             =  etrs//$grid//.//$suffix
$set $SSNOgrid             =  ssno//$grid//.//$suffix
$set $SLIQgrid             =  sliq//$grid//.//$suffix
$set $SSTOgrid             =  ssto//$grid//.//$suffix
$set $sat_def_grid         =  sd__//$grid//.//$suffix
$set $SUZgrid              =  suz_//$grid//.//$suffix
$set $SIFgrid              =  sif_//$grid//.//$suffix
$set $EIgrid               =  ei__//$grid//.//$suffix
$set $SIgrid               =  si__//$grid//.//$suffix
$set $ExpoCorrgrid         =  exco//$grid//.//$suffix
$set $Tcorrgrid            =  tcor//$grid//.//$suffix
$set $Shapegrid            =  shap//$grid//.//$suffix
$set $INFEXgrid            =  infx//$grid//.//$suffix
$set $SATTgrid             =  satt//$grid//.//$suffix
$set $Nagrid               =  na__//$grid//.//$suffix
$set $SSPgrid              =  ssp_//$grid//.//$suffix
$set $Peakgrid             =  peak//$grid//.//$suffix
$set $SBiagrid             =  sbia//$grid//.//$suffix
$set $fcia_grid            =  nfki//$grid//.//$suffix

# now variables for unsaturated zone model
$set $SB_1_grid      =  sb05//$grid//.//$suffix
$set $SB_2_grid      =  sb1_//$grid//.//$suffix
$set $ROOTgrid       =  wurz//$grid//.//$suffix
$set $QDgrid         =  qd__//$grid//.//$suffix
$set $QIgrid         =  qifl//$grid//.//$suffix
$set $GWdepthgrid    =  gwst//$grid//.//$suffix
$set $GWthetagrid    =  gwth//$grid//.//$suffix
$set $GWNgrid        =  gwn_//$grid//.//$suffix
$set $UPRISEgrid     =  uprs//$grid//.//$suffix
$set $PERCOLgrid     =  perc//$grid//.//$suffix
$set $GWLEVELgrid    =  gwlv//$grid//.//$suffix
$set $QDRAINgrid     =  qdrn//$grid//.//$suffix
$set $QBgrid         =  qb__//$grid//.//$suffix
$set $GWINgrid       =  gwin//$grid//.//$suffix
$set $GWEXgrid       =  gwex//$grid//.//$suffix
$set $act_pond_grid  =  pond//$grid//.//$suffix
$set $MACROINFgrid   =  macr//$grid//.//$suffix

# variables for groundwater modeling
$set $flowx1grid     =  gwx1//$grid//.//$suffix
$set $flowx2grid     =  gwx2//$grid//.//$suffix
$set $flowx3grid     =  gwx3//$grid//.//$suffix
$set $flowy1grid     =  gwy1//$grid//.//$suffix
$set $flowy2grid     =  gwy2//$grid//.//$suffix
$set $flowy3grid     =  gwy3//$grid//.//$suffix
$set $head1grid      =  gwh1//$grid//.//$suffix
$set $head2grid      =  gwh2//$grid//.//$suffix
$set $head3grid      =  gwh3//$grid//.//$suffix

# Ergebnis-stacks for Unsatzonmodel
$set $Thetastack              = teth//$stack//.//$suffix
$set $hydraulic_heads_stack   = hhyd//$stack//.//$suffix
$set $geodetic_altitude_stack = hgeo//$stack//.//$suffix
$set $flowstack               = qu__//$stack//.//$suffix
$set $concstack               = conc//$stack//.//$suffix


# parameters for interpolation of meteorological input data
$set $SzenUse        =  0
$set $IDWmaxdist     =  20000
$set $IDWweight      =  2
$set $Anisoslope     =  0.0
$set $Anisotropie    =  1.0


# explanation of writegrid and outputcode some lines below
$set $Writegrid      =  3
$set $Writestack     =  3
$set $outputcode     =  2001
$set $output_meteo   =  2001
$set $day_sum        =  4024
$set $day_mean       =  2024
$set $hour_mean      =  2001
$set $routing_code   =  4001



# readgrids : 1 = read storage grids (as SI, SSNOW,SLIQ,SD,SUZ..) from hard disk, 0=generate and initialize with 0
$set $readgrids     =  0

#
#  Writegrid : max. 3 digits (nnn)
#
#     only if writegrid >= 100: 1. digit (1nn, or 2nn or 3nn)
#      0 = no minimum or maximum grid is written
#      1 = minimum grid is written (minimum value for each of the grid cells over the entire model period)          
#      2 = maximum grid is written (maximum value for each of the grid cells over the entire model period)          
#      1 = both grids are written (minimum and maximum value for each of the grid cells over the entire model period)          
#     only if Writegrid >=  10: 2nd digit: sums or means (n1n ... n8n)
#       0 = no sum grid will be written
#       1 = one sum grid will be written at the end of the model run
#       2 = one sum grid per model year
#       3 = one sum grid per model month
#       4 = one sum grid per day (only, if timestep < 1 day)
#       5 = one mean value grid at the end of the model run
#       6 = one mean value grid per model year
#       7 = one mean value grid per month
#       8 = one mean value grid per day
#     last digit (nn1 .. nn5) (for actual values, not for Sums or means)
#        1 = (over)write each timestep into the same grid (for security in case of model crashs)
#        2 = write grids each timestep to new files, the name is build from the first 4 letters
#            of the regular grid name and then from the number of month, day and hour (hoer as file extension).
#            example: tempm500.grd will become prec0114.07 for 14.January, 7:00.
#        3 = only the last grid of the model run will be stored
#        4 = the grid from the last hour of each day (24:00) will be stored (for each day the same file will be overwritten)
#        5 = like 4, but each day a new grid file is created (like for code 2)
#
# outputcode (for statistic files for zones or subcatchments)
#
# the Codes behind the names of the statistic files have the meaning of:
# <1000   : no output
# 1<nnn>  : spatial mean values for the entire basin, averaged in time over <nnn> intervals (timesteps)
# 2<nnn>  : spatial mean values for all zones (subbasin) and for the entire basin, averaged in time over <nnn> intervals (timesteps)
# 3<nnn>  : spatial means for the entire basin, added up in time over <nnn> intervals (timesteps)
# 4<nnn>  : spatial means for all zones (subbasin) and for the entire basin, added up in time over <nnn> intervals (timesteps)
# 5<nnn>  : spatial means for the entire basin and for those subbasins which are specified in the output-list, averaged in time over <nnn> intervals
# 6<nnn>  : spatial means for the entire basin and for those subbasins which are specified in the output-list, added up in time over <nnn> intervals
#
# example:
#  2001 = per timestep for all subcatchments (and for the entire basin) one (spatially averaged) value,
#  2004 = each 4 time steps one averaged value over the last 4 time steps for all subcatchments and for the entire basin,
#  4024 = Sums of the mean subcatchment/entire basin values of the timesteps over 24 timesteps (e.g. daily rain sums for subcatchments),
#  3120 = averaged values (over 120 time steps!) only for the entire basin (spatially averaged)
#  5012 = averaged values (over 12 timesteps) as spatial averages for the entire basin and for each of the subbasins specified in the output-list

[output_list]
1             # number of subbasins which are scheduled for output (is only of interest, if the code for the statistic files are >5000)
10             # codes for the subbasins

[output_interval]
24             # increment of time steps until an output to the screen is done (24 = each day one output, if time steo = 1h)
1             # warning level for interpolation (no station within search radius)
0             # unit of routed discharge (0=mm/timestep, 1=m3/s)
0              # minutes from the hour-entry in the input data files until the end 
# of the time step is reached 0 if the end of time step is given like "84 01 01 01", 
# but it should be $time if the begin is given like in "84 01 01 00"

[coordinates]
47.4           # geogr. latitude (center of the basin -> for radiation calculations)
9.2            # geogr. longitude (center of the basin)
15.0           # meridian according to the official time (middle europe: 15)(east: 0 ... +180 degree, west: 0 ... -180 (or 360 ... 180)
1              # time shift of Meteo-data-time with respect to the true local time (mean sun time)
# e.g.: if meteo-data are stored in UTC-time and the time meridian is 15 east (central europe),
# than the local time is 1 hour later than the time in the meteo-data-file, so 1 hour has to be added to the time from this file
# this is important for calculation of sunshine duration and radiation

[region_transition_distance]
10000 # in m

[elevation_model]
$inpath//$elevation_model    # grid with the digital elevation data

[zone_grid]
$inpath//$zone_grid          # grid with Zone codes

[standard_grids]
6                            # number of standard grids
$inpath//$land_use_grid         landuse                    1   # grid with land use data
$inpath//$slope_grid            slope_angle                1   # grid with slope angle data
$inpath//$aspect_grid           slope_aspect               1   # grid with slope aspect data
$inpath//$subcatchments         zonegrid_soilmodel         1   # zone grid for the runoff generation model (and unstaurated zone model)
$inpath//$soil_types            soil_types                 1   # soil types as codes for the soil table
$inpath//$flow_time_grid        flow_times                 1   # grid with flow times for surface runoff to the subbasin outlet
$inpath//$hydr_cond_grid        hydraulic_conductivity     1   # grid with hydraulic conductivity of the soil -> old soilmodel
$inpath//$field_capacity_grid   available_soil_moisture    1   # grid with available soil moisture at field capacity [mm] -> old soil model
$inpath//$ATBgrid               topographic_faktor         1   # soil-topograhic-factor ln(A/(T*tanb))
$inpath//$tracer_1             concflux_tracer_1_input     1
$inpath//$tracer_2             concflux_tracer_2_input     1
$inpath//$tracer_3             concflux_tracer_3_input     1
$inpath//$tracer_4             concflux_tracer_4_input     1 
$inpath//$tracer_5             concflux_tracer_5_input     1
$inpath//$tracer_6             concflux_tracer_6_input     1
$inpath//$tracer_7             concflux_tracer_7_input     1
$inpath//$tracer_8             concflux_tracer_8_input     1 
$inpath//$tracer_9             concflux_tracer_9_input     1
$inpath//$river_depth_grid      river_depth                0    # grid with the depth of all streams in the stream network in m
$inpath//$river_width_grid      river_width                0    # grid with the witdh of all streams in m
$inpath//$river_links_grid      river_links                0    # grid with codes of tributaries, from which a channel was routed (only for real routing channels!!!)
$inpath//$kolmationsgrid        kolmation                  0    # grid with codes of tributaries, from which a channel was routed (only for real routing channels!!!)
$inpath//$drain_depth_grid      drainage_depth             1    # grid with depth of drainage pipes in the soil
$inpath//$drain_distance_grid   drainage_distance          1    # grid with distances of the drainage pipes or hoses from each other
$inpath//$clay_depth_grid       clay_depth                 1    # grid with the depth of an unpermeable layer (0 if no clay layer exists
$inpath//$max_pond_grid         max_ponding_storage        1    # grid with height of small dams around the fields for water ponding (in m). 0 if no ponding occurs
$inpath//$irrigationcodes       irrigation_codes           1    # grid with codes according to the irrigation table
$inpath//$aquiferthick1         aquifer_thickness_1        1    # grid with thickness of first aquifer (m from soil surface to the aquifer bottom)
$inpath//$gw_storage_coeff_1    gw_storage_coeff_1         1    # storage coefficients for 1. aquifer
$inpath//$gw_bound_h_1_grid     gw_boundary_fix_h_1        0    # boundary conditions 1 constant head for layer 1
$inpath//$gw_bound_q_1_grid     gw_boundary_fix_q_1        0    # boundary conditions 2 (given flux perpendicular to the border) for layer 1
$inpath//$gw_kx_1_grid          gw_k_x_1                   1    # lateral hydraulic conductivities for the 1. aquifer in x direction
$inpath//$gw_ky_1_grid          gw_k_y_1                   1    # lateral hydraulic conductivities for the 1. aquifer in y direction
$inpath//$gw_kolmation_1        gw_kolmation_1             1    # kolmation (leakage factor) between 1st and 2nd aquifer
$inpath//$aquiferthick2         aquifer_thickness_2        1    # grid with thickness of first aquifer (m from soil surface to the aquifer bottom)
$inpath//$gw_storage_coeff_2    gw_storage_coeff_2         1    # storage coefficients for 1. aquifer
$inpath//$gw_bound_h_2_grid     gw_boundary_fix_h_2        0    # boundary conditions 1 constant head for layer 1
$inpath//$gw_bound_q_2_grid     gw_boundary_fix_q_2        0    # boundary conditions 2 (given flux perpendicular to the border) for layer 1
$inpath//$gw_kx_2_grid          gw_k_x_2                   1    # lateral hydraulic conductivities for the 1. aquifer in x direction
$inpath//$gw_ky_2_grid          gw_k_y_2                   1    # lateral hydraulic conductivities for the 1. aquifer in y direction
$inpath//$gw_kolmation_2        gw_kolmation_2             1    # kolmation (leakage factor) between 2nd and 3rd aquifer

# variable grids are used by more than one module or can be changed (like albedo and soil storage)

[variable_grids]
2                                               # Number of variable grids to read
$outpath//$albedo              albedo        1  # albedo; for time without snow derived from land use data
$Writegrid                                      # Writegrid for albedo_grid
$readgrids                                      # 0, if albedo is derived from land use at model start time, 1, if albedo is read from file
$outpath//$soilstoragegrid     soil_storage  1  # soil water storage
$Writegrid                                      # Writegrid for this grid
$readgrids                                      # 0, if soil_storage should be derived from soil types, 1, if it should be read from file

[model_time]
1                     #  start hour
1                     #  start day
1                     #  start month
19//$year             #  start year
24                    #  end hour
31                    #  end day
12                    #  end month
19//$year             #  end year

[meteo_data_count]
6

[meteo_names]
precipitation
temperature
vapor_pressure
global_radiation
wind_speed
sunshine_duration
air_humidity

[temperature]
2                             # Methode 1=idw, 2=regress, 3=idw+regress, 4=Thiessen
$inpath//t2m___//$year//.dat AdditionalColumns=0 # file name with station data (if method = 1, 3 or 4, else ignored)
$inpath//t2m___//$year//.out  # file name with regression data (if method = 2 or 3)
$outpath//$tempegrid          # name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
$Writegrid                    # 0, if no grid-output is needed, else one of the codes described above
0.1                           # correction faktor for results
$outpath//temp//$grid//.//$code//$year $hour_mean # file name for the statistic output (statially averaged values per time step and subcatchment...)
998                           # error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    # weighting of the reciprocal distance for IDW
0.1                           #  for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   #  max. distance of stations to the actual interpolation cell
$Anisoslope                   #  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  #  ratio of the short to the long axis of the anisotropy-ellipsis
-40                           #  lower limit of interpolation results
-40                           #  replace value for results below the lower limit
40                            #  upper limit for interpolation results
40                            #  replace value for results with larger values than the upper limit
$SzenUse                      #  1=use scenario data for correction, 0=dont use scenarios
1                             #  1=add scenarios, 2=multiply scenarios, 3=percentual change
4                             #  number of scenario cells

[wind_speed]
2                             # method: 1=idw 2=regress 3=idw+regress 4=thiessen
$inpath//wind__//$year//.dat AdditionalColumns=0  # file name with station data (if method = 1, 3 or 4, else ignored)
$inpath//wind__//$year//.out  # file name with regression data (if method = 2 or 3)
$outpath//$windgrid           # name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
$Writegrid                    # 0, if no grid-output is needed, else one of the codes described above
0.1                           # correction faktor for results
$outpath//wind//$grid//.//$code//$year $hour_mean  # file name for the statistic output (statially averaged values per time step and subcatchment...)
998                           # error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    # weighting of the reciprocal distance for IDW
0.3                           # for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   # max. distance of stations to the actual interpolation cell
$Anisoslope                   # slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  #  ratio of the short to the long axis of the anisotropy-ellipsis
0                             # lower limit of interpolation results
0                             # replace value for results below the lower limit
90                            # upper limit for interpolation results
90                            # replace value for results with larger values than the upper limit
$SzenUse                      # 1=use scenario data for correction, 0=dont use scenarios
3                             # 1=add scenarios, 2=multiply scenarios, 3=percentual change
4                             # number of scenario cells

[precipitation]
3                             # method: 1=idw 2=regress 3=idw+regress 4=thiessen 5=bilinear 6=bilinear gradients and residuals linarly combined
$inpath//prec__//$year//.dat AdditionalColumns=0   # file name with station data (if method = 1, 3 or 4, else ignored)
$inpath//prec__//$year//.out  # file name with regression data (if method = 2 or 3)
$outpath//$preci_grid         # name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
$Writegrid                    # 0, if no grid-output is needed, else one of the codes described above
0.1                           # correction faktor for results
$outpath//prec//$grid//.//$code//$year $hour_mean  # file name for the statistic output (statially averaged values per time step and subcatchment...)
998                           # error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    # weighting of the reciprocal distance for IDW
0.75                          # for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   # max. distance of stations to the actual interpolation cell
$Anisoslope                   #  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  #  ratio of the short to the long axis of the anisotropy-ellipsis
0.1                           # lower limit of interpolation results
0                             # replace value for results below the lower limit
900                           # upper limit for interpolation results
900                           # replace value for results with larger values than the upper limit
$SzenUse                      # 1=use scenario data for correction, 0=dont use scenarios
2 # 3                         # 1=add scenarios, 2=multiply scenarios, 3=percentual change
1 # 4                         # number of scenario cells

[sunshine_duration]
1                             # method: 1=idw 2=regress 3=idw+regress 4=thiessen
$inpath//ssd___//$year//.rel AdditionalColumns=0  # file name with station data (if method = 1, 3 or 4, else ignored)
$inpath//ssd___//$year//.out  # file name with regression data (if method = 2 or 3)
$outpath//$sunshinegrid       # name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
$Writegrid                    # 0, if no grid-output is needed, else one of the codes described above
1.0                           # correction faktor for results
$outpath//ssd_//$grid//.//$code//$year  $hour_mean  # file name for the statistic output (statially averaged values per time step and subcatchment...)
998                           # error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    # weighting of the reciprocal distance for IDW
0.5                           # for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   # max. distance of stations to the actual interpolation cell
$Anisoslope                   # slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  # ratio of the short to the long axis of the anisotropy-ellipsis
0                             # lower limit of interpolation results
0                             # replace value for results below the lower limit
1.0                           # upper limit for interpolation results
1.0                           # replace value for results with larger values than the upper limit
$SzenUse                      # 1=use scenario data for correction, 0=dont use scenarios
3                             # 1=add scenarios, 2=multiply scenarios, 3=percentual change
1                             # number of scenario cells

[global_radiation]
2                             # method: 1=idw 2=regress 3=idw+regress 4=thiessen
$inpath//glob__//$year//.dat AdditionalColumns=0  # file name with station data (if method = 1, 3 or 4, else ignored)
$inpath//glob__//$year//.out  # file name with regression data (if method = 2 or 3)
$outpath//$radiationgrid      # name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
$Writegrid                    # 0, if no grid-output is needed, else one of the codes described above
1.0                           # correction faktor for results
$outpath//rad_//$grid//.//$code//$year $hour_mean  # file name for the statistic output (statially averaged values per time step and subcatchment...)
9998                          # error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    # weighting of the reciprocal distance for IDW
0.5                           # for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   # max. distance of stations to the actual interpolation cell
$Anisoslope                   #  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  #  ratio of the short to the long axis of the anisotropy-ellipsis
0                             # lower limit of interpolation results
0                             # replace value for results below the lower limit
1367                          # upper limit for interpolation results
1367                          # replace value for results with larger values than the upper limit
$SzenUse                      # 1=use scenario data for correction, 0=dont use scenarios
1                             # 1=add scenarios, 2=multiply scenarios, 3=percentual change
4                             # number of scenario cells

[air_humidity]
2                             # method: 1=idw 2=regress 3=idw+regress 4=thiessen
$inpath//humi__//$year//.dat AdditionalColumns=0  # file name with station data (if method = 1, 3 or 4, else ignored)
$inpath//humi__//$year//.out  # file name with regression data (if method = 2 or 3)
$outpath//$humiditygrid       # name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
$Writegrid                    # 0, if no grid-output is needed, else one of the codes described above
0.001                         # correction faktor for results
$outpath//humi//$grid//.//$code//$year $hour_mean # file name for the statistic output (statially averaged values per time step and subcatchment...)
9998                          # error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    # weighting of the reciprocal distance for IDW
0.5                           # for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   # max. distance of stations to the actual interpolation cell
$Anisoslope                   #  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  #  ratio of the short to the long axis of the anisotropy-ellipsis
0.01                          # lower limit of interpolation results
0.01                          # replace value for results below the lower limit
1.0                           # upper limit for interpolation results
1.0                           # replace value for results with larger values than the upper limit
$SzenUse                      # 1=use scenario data for correction, 0=dont use scenarios
3                             # 1=add scenarios, 2=multiply scenarios, 3=percentual change
1                             # number of scenario cells

[vapor_pressure]
2                             # method: 1=idw 2=regress 3=idw+regress 4=thiessen
$inpath//vapr__//$year//.dat AdditionalColumns=0  # file name with station data (if method = 1, 3 or 4, else ignored)
$inpath//vapr__//$year//.out  # file name with regression data (if method = 2 or 3)
$outpath//$vaporgrid          # name of the output grid (is also used for deriving names of daily, monthly, yearly sums or averages)
$Writegrid                    # 0, if no grid-output is needed, else one of the codes described above
0.1                           # correction faktor for results
$outpath//vapo//$grid//.//$code//$year $hour_mean # file name for the statistic output (statially averaged values per time step and subcatchment...)
998                           # error value: all data in the input file greater than this values or lesser the negative value are nodata
$IDWweight                    # weighting of the reciprocal distance for IDW
0.5                           # for interpolation method 3: relative weight of IDW-interpolation in the result
$IDWmaxdist                   # max. distance of stations to the actual interpolation cell
$Anisoslope                   #  slope of the mean axis of the anisotropy-ellipsis (-90 ... +90 degree, mathem. positive)
$Anisotropie                  #  ratio of the short to the long axis of the anisotropy-ellipsis
0                             # lower limit of interpolation results
0                             # replace value for results below the lower limit
90                            # upper limit for interpolation results
90                            # replace value for results with larger values than the upper limit
$SzenUse                      # 1=use scenario data for correction, 0=dont use scenarios
1                             # 1=add scenarios, 2=multiply scenarios, 3=percentual change
4                             # number of scenario cells


# ----------  parameter for model components  -----------------
#

# for precipitation correction the paragraphs "precipitation" "temperature" and
# "wind_speed" are searched in the memory. If thea are not there (no definition in the control file for precipitation, wind or temperature),
# the prec. corr. will not be calculated

[precipitation_correction]
1                     # 0=ignore this module, 1 = run the module
0.0                   # Snow-rain-temperature
1.05                  # liquid:   b in:  y = p(ax + b)
0.05                  # liquid:   a in:  y = p(ax + b) = 1% more per m/s + 0.5% constant
1.20                  # Snow:     b in:  y = p(ax + b)
0.25                  # Snow:     a in:  y = p(ax + b) = 15% more per m/s + 45% constant

# corretion factors for direct radiation are calculated
# if the cell is in the shadow of another cell, or if a cell is not in the sun (slope angle!)
# then the factor is 0.
# control_parameter: 1 = radiation correction WITH  shadow WITHOUT temperature correction
#                    2 = radiation correction WITH  shadow WITH  temperature correction
#                    3 = radiation correction WITHOUT shadow WITHOUT temperature correction,
#                    4 = radiation correction WITHOUT shadow WITH  Temperatur


[radiation_correction]
1                    # 0=ignore this module, 1 = run the module
$time                # duration of a time step in minutes
2                    # control parameter for radiation correction (see above)
$outpath//$Tcorrgrid # name of the grids with the corrected temperatures
$Writegrid           # Writegrid for corrected temperatures
5                    # factor x for temperature correction x * (-1.6 .... +1.6)
$outpath//$ExpoCorrgrid   # name of the grids with the correction factors for the direct radiation
$Writegrid           # Writegrid
$outpath//$Shapegrid # name of the grids for codes 1 for theor. shadow, 0 for theor. no shadow (day; assumed: SSD=1.0)
$Writegrid           # Writegrid
1                    # interval counter, after reaching this value, a new correction is calculated (3=all 3 hours a.s.o.)
1                    # Spitting of the interval, usefull for time step=24 hours (then: split=24, -> each hour one correction calculation)


[evapotranspiration]
1                        # 0=ignore this module, 1 = run the module
$time                    # duration of a time step in minutes
1                        # Method: 1=Penman-Monteith, 2=Hamon (only daily), 3=Wendling (only daily) 4= Haude (only daily)
0.5  0.6  0.8  1.0  1.1 1.1 1.2 1.1 1.0 0.9 0.7 0.5  # PEC correction factor for HAMON-evapotranspiration
0.20 0.20 0.21 0.29 0.29 0.28 0.26 0.25 0.22 0.22 0.20 0.20 # fh (only for method 4: Haude) monthly values (Jan ... Dec) (here: for Grass)
0.5                      # fk -> factor for Wendling-evapotranspiration (only for Method = 3)
$outpath//$ETPgrid       # result grid for pot. evapotranspiration in mm/dt
$Writegrid               # 0, if no grid-output is needed, else one of the codes described above
$outpath//etp_//$grid//.//$code//$year $hour_mean # statisticfile for Teilgebiete of pot. evapo-Transpiration
$outpath//$ETRgrid       # result grid for real evapotranspiration in mm/dt
$Writegrid               # 0, if no grid-output is needed, else one of the codes described above
$outpath//etr_//$grid//.//$code//$year $hour_mean # statistic for subcatchments (zones) of the real evapotranspiration
$outpath//$EVAPgrid      # result grid for real evapotranspiration in mm/dt
$Writegrid               # 0, if no grid-output is needed, else one of the codes described above
$outpath//evap//$grid//.//$code//$year $hour_mean # statistic for subcatchments (zones) of the potential evaporation
$outpath//$EVARgrid      # result grid for real evapotranspiration in mm/dt
$Writegrid               # 0, if no grid-output is needed, else one of the codes described above
$outpath//evar//$grid//.//$code//$year $hour_mean # statistic for subcatchments (zones) of the real evaporation
$outpath//$ETRSgrid	 # result grid for real snow evapotranspiration in mm/dt
1//$Writegrid        	 # 0, if no grid-output is needed, else one of the codes described above
$outpath//etrs//$grid//.//$code//$year $hour_mean # statistic for subcatchments (zones) of the real snow evaporation
$outpath//$EIPgrid       # result grid for pot. interception evaporation in mm/dt
$Writegrid               # 0, if no grid-output is needed, else one of the codes described above
$outpath//eip_//$grid//.//$code//$year $hour_mean # statisticfile for zones of pot. interception evaporation
$outpath//rgex//$grid//.//$code//$year $hour_mean # statistic for subcatchments (zones) of the corrected radiation
+0.23   +1.77    -2.28    +1.28    # coefficients c for Polynom of order 3 RG = c1 + c2*SSD + c3*SSD^2 + c4*SSD^3
+0.072  -0.808   +2.112   -0.239   # coefficients x for Polynom of order 3 SSD = x1 + x2*RG + x3*RG^2 + x4*RG^3
0.88 0.05                          # Extinktion coefficient for RG-modeling (Phi and dPhi) (summer phi = phi-dphi, winter phi=phi+dphi)
1654.0                             # recession constant (e-function for recession of the daily temperature amplitude with altitude [m]
3.3  4.4  6.1  7.9  9.4  10.0  9.9  9.0  7.8  6.0  4.2  3.2  # monthly values of the max. daily T-amplitudes (for 0 m.a.s.l)
0.62  0.1                          # part of the temperature amplitude (dt), that is added to the mean day-temperature
# (followed by the range of changing within a year ddt) to get the mean temperature of light day
# in the night: mean night temperature is mean day temperature minus (1-dt)*(temp. amplitude)


[snow_model]
1                    # 0=ignore this module, 1 = run the module
$time                # duration of a time step in minutes
1                    # method 1=T-index, 2=t-u-index, 3=Anderson comb., 4=extended com.
1.0                  # transient zone for rain-snow (T0R +- this range)
0.6                  # T0R    temperature limit for rain (Grad Celsius)
-0.5                 # T0     temperature limit snow melt
0.1                  # CWH    storage capacity of the snow for water (relative part)
1.0                  # CRFR   coefficient for refreezing
1.8                  # C0     degree-day-factor mm/d/C
1.0                  # C1     degree-day-factor without wind consideration  mm/(d*C)
0.8                  # C2     degree-day-factor considering wind mm/(d*C*m/s)
0.07                 # z0     roughness length cm for energy bilance methods (not used)
1.5                  # RMFMIN minimum radiation melt factor      mm/d/C comb. method
2.5                  # RMFMAX maximum radiation melt factor      mm/d/C comb. method
0.40                 # Albedo for snow (Min)
0.85                 # Albedo for snow (Max)
$outpath//$rain_rate         # rain rate
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//rain//$grid//.//$code//$year $hour_mean # rain rate
$outpath//$snow_rate         # snow rate
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//snow//$grid//.//$code//$year $hour_mean # snow rate
$outpath//$days_snow         # days with snow (SWE > 5mm)
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//sday//$grid//.//$code//$year $hour_mean # days with snow (SWE > 5mm)
$outpath//$snow_age          # snow age (days without new snow)
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//sage//$grid//.//$code//$year $hour_mean # days since last snowfall
$outpath//albe//$grid//.//$code//$year $hour_mean # Albedo
$outpath//$snowcover_outflow # discharge from snow, input (precipitation) for following modules
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//qsch//$grid//.//$code//$year $hour_mean # melt flow (or rain, if there is no snow cover) in mm/dt
$outpath//$melt_from_snowcover # discharge from snow, input (precipitation) for following modules
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//qsme//$grid//.//$code//$year $hour_mean # melt flow in mm/dt
$outpath//$SSNOgrid          # name of the grids with the snow storage solid in mm
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//$SLIQgrid          # name of the grids with the snow storage liquid in mm
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//ssto//$grid//.//$code//$year $hour_mean # total snow storage, in mm, (liquid and solid fraction)
$outpath//$SSTOgrid          # name of the grids with the total snow storage solid AND liquid in mm
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$readgrids                   # 1=read snow storage solid, liquid grids from disk, 0=generate new grids


[ice_firn]
2   # method for glacier melt: 1=classical t-index, 2=t-index with correction by radiation 
5   # t-index factor for ice
4   # t-index factor for firn
3   # t-index factor for snow
2   # melt factor
0.0001   # radiation coefficient for ice_min  (for method 2)
0.0007   # radiation coefficient for ice_max  (for method 2)
0.0001   # radiation coefficient for snow_min (for method 2)
0.00055  # radiation coefficient for snow_max (for method 2)
40        # els-konstante for ice
350       # els-konstante for firn
120       # els-konstante for snow
0.0006    # initial reservoir content for ice discharge (single linear storage approach)
0.0006    # initial reservoir content for firn discharge (single linear storage approach)
0.0006    # initial reservoir content for snow discharge (single linear storage approach)
$outpath//$firn_melt # melt from firn
$Writegrid           # 0, if no grid-output is needed, else one of the codes described above
$outpath//qfir//$grid//.//$code//$year $hour_mean # melt from firn as statistic file
$outpath//$ice_melt  # melt from ice
$Writegrid           # 0, if no grid-output is needed, else one of the codes described above
$outpath//qice//$grid//.//$code//$year $hour_mean # melt from ice as statistic file
$outpath//qglc//$grid//.//$code//$year $hour_mean # discharge from snow, ice and firn as statistic file


[interception_model]
1                            # 0=ignore this module, 1 = run the module
$time                        # duration of a time step in minutes
2			     # method: 1 = use ETP for calculating EI; 2 = use EIP for calculating EI (only effective for method 1 in evapotranspiration model -> for other methods, ETP = EIP)
$outpath//$throughfall       # result grid :  = outflow from the interception storage
$Writegrid                    0, if no grid-output is needed, else one of the codes described above
$outpath//qi__//$grid//.//$code//$year $hour_mean # statistic file interception storage outflow
$outpath//$EIgrid            # Interzeption evaporation, grid
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//ei__//$grid//.//$code//$year $hour_mean # zonal statistic
$outpath//$SIgrid            # storage content of the interception storage
$Writegrid                   # 0, if no grid-output is needed, else one of the codes described above
$outpath//si__//$grid//.//$code//$year $hour_mean # zonal statistic For interception storage content
0.35                         # layer thickness of the waters on the leaves (multiplied with LAI -> storage capacity)
$readgrids                   # 1=read grids from disk, else generate internal


[infiltration_model]
0                            # 0=ignore this module, 1 = run the module
$time                        # duration of a time step in minutes
$outpath//$INFEXgrid         # grid with infiltration excess in mm (surface runoff)
$Writegrid                   # Writecode for this grid
$outpath//infx//$grid//.//$code//$year $hour_mean # statistic file for the infiltration excess
$outpath//$SATTgrid          # grid with code 1=saturation at interval start, 0 =no saturation.
$Writegrid                   # Writecode for this grid
0.1                          # fraction of reinfitrating water (of the infiltration excess)


[unsatzon_model]
1                            # 0=ignore this module, 1 = run the module
$time                        # duration of a time step in minutes
2                            # method, 1=simple method, 2 = FDM-Method (strongly recommended)
2  # controlling interaction with surface water: 0 = no interaction, 1 = exfitration possible 2 = infiltration and exfiltration possible
0  # controlling surface storage in ponds:       0 = no ponds,       1 = using ponds for surface storage (pond depth as standard grid needed -> height of dams oround fields)
0  # controlling artificial drainage:            0 = no artificial drainage 1 = using drainage (drainage depth and horizontal pipe distances as standard grids needed!)
0  # controlling clay layer:                     0 = no clay layer,  1 = assuming a clay layer in a depth, specified within a clay-grid (declared as a standard grid)
5e-8                         # permeability of the clay layer (is used for the clay layer only)
2.6  # parameter for the initialization of the gw_level (range between 1..levels (standard: 4))
$outpath//qdra//$grid//.//$code//$year $hour_mean # results drainage discharge in mm per zone
$outpath//gwst//$grid//.//$code//$year $hour_mean # results groundwater depth
$outpath//gwn_//$grid//.//$code//$year $hour_mean # results mean groundwater recharge per zone
$outpath//sb05//$grid//.//$code//$year $hour_mean # results rel. soil moisture within the root zone per zone
$outpath//sb1_//$grid//.//$code//$year $hour_mean # results rel. soil moisture within the unsat. zone (0m..GW table) per zone
$outpath//wurz//$grid//.//$code//$year $hour_mean # results statistic of the root depth per zone
$outpath//infx//$grid//.//$code//$year $hour_mean # results statistic of the infiltration excess
$outpath//pond//$grid//.//$code//$year $hour_mean # results statistic of the ponding water storage content
$outpath//qdir//$grid//.//$code//$year $hour_mean # results statistic of the direct discharge
$outpath//qifl//$grid//.//$code//$year $hour_mean # results statistic of the interflow
$outpath//qbas//$grid//.//$code//$year $hour_mean # results statistic of the baseflow
$outpath//qges//$grid//.//$code//$year $hour_mean # results statistic of the total discharge
$outpath//gwin//$grid//.//$code//$year $hour_mean # statistic of the infiltration from surface water into groundwater (from rivers and lakes)
$outpath//gwex//$grid//.//$code//$year $hour_mean # statistic of the exfiltration from groundwater into surface water (into rivers and lakes)
$outpath//macr//$grid//.//$code//$year $hour_mean # statistic of infiltration into macropores
$outpath//qinf//$grid//.//$code//$year $hour_mean # statistic of total infiltration into the first soil layer
$outpath//$SB_1_grid         # grid with actual soil water content for the root zone
$Writegrid                   # Writecode for this grid
$outpath//$SB_2_grid         # grid with actual soil water content for the entire unsaturated zone
$Writegrid                   # Writecode for this grid
$outpath//$ROOTgrid          # grid with root depth 
$Writegrid                   # Writecode for this grid
$outpath//$Thetastack        # stack, actual soil water content for all soil levels
$Writestack                  # Writecode for this stack
$outpath//$hydraulic_heads_stack   # stack, contaiing hydraulic heads
$Writestack                  # Writecode for this stack
$outpath//$geodetic_altitude_stack   # stack, containig geodaetic altitudes of the soil levels (lower boudaries)
$Writestack                  # Writecode for this stack
$outpath//$flowstack         # stack, containing the outflows from the soil levels
$Writestack                  # Writecode for this stack
$outpath//$GWdepthgrid       # grid with groudwaterdepth
$Writegrid                   # Writecode for this grid
$outpath//$GWthetagrid       # grid with theta in GWLEVEL
$Writegrid                   # Writecode for this grid
$outpath//$GWNgrid           # grid with groundwater recharge
$Writegrid                   # Writecode for this grid
$outpath//$GWLEVELgrid       # grid with level index of groundwater surface (Index der Schicht)
$Writegrid                   # Writecode for this grid
$outpath//$QDRAINgrid        # grid with the drainage flows
$Writegrid                   # Writecode for this grid
$outpath//$SATTgrid          # grid with code 1=saturation at interval start, 0 no sat.
$Writegrid                   # Writecode for this grid
$outpath//$INFEXgrid         # grid with infiltration excess in mm (surface discharge)
$Writegrid                   # Writecode for this grid
$outpath//$QDgrid            # grid with direct discharge
$Writegrid                   # Writecode for this grid
$outpath//$QIgrid            # grid with Interflow
$Writegrid                   # Writecode for this grid
$outpath//$QBgrid            # grid with baseflow
$Writegrid                   # Writecode for this grid
$outpath//$GWINgrid          # grid with infiltration from rivers into the soil (groundwater)
$Writegrid                   # Writecode for this grid
$outpath//$GWEXgrid          # grid with exfiltration (baseflow) from groundwater (is only generated, if groundwater module is active, else baseflow is in QBgrid)
$Writegrid                   # Writecode for this grid
$outpath//$act_pond_grid     # grid with content of ponding storge
$Writegrid                   # Writecode for this grid
$outpath//$UPRISEgrid        # grid with amount of capillary uprise (mm)
$Writegrid                   # Writecode for this grid
$outpath//$PERCOLgrid        # grid with amount of percolation (mm)
$Writegrid                   # writegrid for this grid
$outpath//$MACROINFgrid      # grid with amount of infiltration into macropores (mm)
$Writegrid                   # Writecode for this grid
3 3 # coordinates of control plot, all theta and qu-values are written to files (qu.dat, theta.dat in the directory, from which the model is started)
$outpath//qbot//$grid//.//$code//$year  	# name of a file containing the flows between the layers of the control point
$outpath//thet//$grid//.//$code//$year  	# name of a file containing the soil moisture as theta values of the layers of the control point
$outpath//hhyd//$grid//.//$code//$year  	# name of a file containing the hydraulic head of the layers of the control point
$outpath//otherdata//$grid//.//$code//$year  	# name of a file containing some other water balance data of the control point (non layer data)
$outpath//etrd//$grid//.//$code//$year  	# name of a file containing the withdrawal of soil water for each layer for the control point (due to transpiration)
$outpath//intd//$grid//.//$code//$year  	# name of a file containing the interflow for the soil layers of the control point
10	#  codes of the subbasins (in the subbasin grid) 
1	#  recession parameters QD (h)
1	#  recession parameters QI (h)
35	#  flow density (for Interflow, channels per km)
0.45	#  recession parameters k for Base discharge (in QB = Q0*exp(-k/z))
0.1	#  correction of transmissivities Q0 for Baseflow in QB = Q0 * exp(-k/z)
0.2	#  fraction of snow melt, which is direct flow (no infiltration)
$readgrids               	# meanings are extended now! read the follwing comments
$outpath//storage_richards.ftz	# if readgrids = 1, then this file contains the contents of the flow travel time zones for interflow and surface flow and for the tracers

[ExternalCoupling]
0 # 0 = no coupling, 1=coupling
$exchngpath//wasim.inf  # name of the semaphore file to inform wasim that all grids written by the groundwater model are available now
50   # wait interval in ms between scanning the directory for the new semaphore file (wasim for windows will use a second thread to minimize CPU time, whereas wasim as 
# console application will use 100% CPU time while waiting for the output file of the groundwater model. The wait time is then used to minimize disk access
# A follwing version will use a DLL with a memory pointer to the required grid and a flag, which is used by both programs to couple the models. 
# But this is music for the future yet...
H     # Coupling mode: I=each interval, H=each hour, D=each Day, M=each month, Y=each year
60  # time interval in minutes, the external model uses. This is important to convert changes in groundwater level into fluxes as used by WaSiM
1     # number of following grid names which must be available once the semaphore file was written. Each following row (1..n) will contain a symbolic name 
# (grid names from modconst.h) Thus, any grid may be read in, even for other sub models like the boundary conditions as gw_boundary_fix_h_1 for the first aquifer or a changed landuse grid a.s.o.
$exchngpath//gwtable.grd GWTableExtern 1 0 # the first value is the file name, the second the internal grid name (see English-section in modconst.h ), the third parameter is the fillMissings-parameter (0=no fill, 1=fill with nearest neighbors value), the last ine is the rename(1)/delete(0) parameter
#$exchngpath//bh.grd      gw_boundary_fix_h_1 0 0 # the first value is the file name, the second the internal grid name (see English-section in modconst.h ), the third parameter is the fillMissings-parameter (0=no fill, 1=fill with nearest neighbors value), the last ine is the rename(1)/delete(0) parameter
2     # number of grids (each matching one of the following rows) which should be written when the next synchronisation is due
$exchngpath//gwn.grd      groundwater_recharge  Mean   # hier als Beispiel das Grid mit der Grundwasserneubildung
#$exchngpath//gwstand.grd  groundwater_distance  Last   # hier als Beispiel das Grid mit der Grundwasserneubildung
$exchngpath//balance.grd  Balance  Sum  # hier als Beispiel das Grid mit der Bilanz aller Wasserinhaltsnderungen durch die Kopplung (sollte 0 sein)
2     # number of subbasin correlated statistics (mean values) which should be written as table (in ASCII-Format) (this is actually limited to directflow and interflow)
$exchngpath//qdir.table direct_discharge Sum # direct flow per subbasin/zone in mm
$exchngpath//difl.table Interflow Sum # interflow per subbasin/zone in mm
$exchngpath//geofim.inf # name of the semaphore file wasim will write after all of the output above was written
geofim # content of the semaphore file 

[irrigation]
0                            # 0=ignore this module, 1 = run the module
$time                        # duration of a time step in minutes
$outpath//irgw//$grid//.//$code//$year $hour_mean # statistic of the irrigation water from groundwater
$outpath//irsw//$grid//.//$code//$year $hour_mean # statistic of the irrigation water from surface water

[groundwater_flow]
0                        # 0=ignore the module, 1 = run the module
$time                    # duration of a time step in minutes; doen't change the value unless you have strong reasons to do so!!
1                        # solving method: 1=Gauss-Seidel-iteration (using alpha for control wether it is explicite, partly or fully implicite), 2=PCG (not yet implemented
1000                     # if iterative solving method (1): max.numberof iterations
0.00001                  # if iterative solving method (1): max. changes between two iterations
1.0                      # Alpha for estimation of central differences 0.5 = Crank-Nicholson Method, 0 = fully explicite, 1 = fully implicite
-1.30                    # factor for relaxing the iteration if using iterativemethod (successive over[/under] relaxation) 
$readgrids             	 # 1=read grids for heads from disk, 0=do not read but initialize with gw-level from unsaturated zone
1                        # number of layers 
3 3                      # coordinates of a control point for all fluxes and for each layer : q0..q4, leakage up and down
$outpath//glog//$grid//.//$code//$year  # name of a file containing the flows between of the control point
$outpath//$head1grid     # (new) grid for hydraulic heads for layer 1
$Writegrid           	 # writecode for hydraulic heads for layer 1
$outpath//$flowx1grid    # (new) grid for fluxes in x direction for layer 1
$Writegrid           	 # writecode for flux-x-grid in layer 1
$outpath//$flowy1grid    # (new) grid for fluxes in y direction for layer 1
$Writegrid           	 # writecode for flux-y-grid in layer 1
$outpath//$head2grid     # (new) grid for hydraulic heads for layer 2
$Writegrid           	 # writecode for hydraulic heads for layer 2
$outpath//$flowx2grid    # (new) grid for fluxes in x direction for layer 2
$Writegrid          	 # writecode for flux-x-grid in layer 2
$outpath//$flowy2grid    # (new) grid for fluxes in y direction for layer 2
$Writegrid           	 # writecode for flux-y-grid in layer 2
$outpath//$head3grid     # (new) grid for hydraulic heads for layer 3
$Writegrid           	 # writecode for hydraulic heads for layer 3
$outpath//$flowx3grid    # (new) grid for fluxes in x direction for layer 3
$Writegrid               # writecode for flux-x-grid in layer 3
$outpath//$flowy3grid    # (new) grid for fluxes in y direction for layer 3
$Writegrid               # writecode for flux-y-grid in layer 3


# this paragraph is not needed for WaSiM-uzr but for the WaSiM-version with the variable saturated area approach (after Topmodel)
[soil_model]
0                        # 0=ignore this module, 1 = run the module
$time                    # duration of a time step in minutes
1                        # method, 1 = without slow baseflow, 2 = with slow baseflow (not recommended)
$outpath//$sat_def_grid  # (new) saturation deficite-grid (in mm)
$Writegrid               # writegrid for this grid
$outpath//$SUZgrid       # (new) storage grid for unsat. zone
$Writegrid               # writegrid for this grid
$outpath//$SIFgrid       # (new) storage grid for interflow storage
$Writegrid               # writegrid for this grid
$outpath//$SBiagrid      # (new) grid for soil moisture in the inaktive soil storage
$Writegrid               # Writegrid for inaktive soil moisture
$outpath//$fcia_grid     # (new) grid for plant available field capacity in the  inaktiven soil storage
$Writegrid               # writegrid for this grid
$outpath//$SSPgrid       # (new) grid for the relative fraction of the soil storages, which is in contact with ground water
$Writegrid               # writegrid for this grid
$outpath//$QDgrid        # (new) grid for surface runoff
$Writegrid               # writegrid for this grid
$outpath//$QIgrid        # (new) grid for Interflow
$Writegrid               # writegrid for this grid
$outpath//$Peakgrid      # (new) grid for Peakflow (maximum peakflow for the entire model time)
$outpath//qdir//$grid//.//$code//$year $hour_mean # statistic of the surfeca discharge
$outpath//qifl//$grid//.//$code//$year $hour_mean # statistic of the Interflows
$outpath//qbas//$grid//.//$code//$year $hour_mean # statistic of the base flow
$outpath//qbav//$grid//.//$code//$year $hour_mean # statistic of the slow base flow
$outpath//qges//$grid//.//$code//$year $hour_mean # statistic of the total discharge
$outpath//sb__//$grid//.//$code//$year $hour_mean # soil storage in mm per zone
$outpath//suz_//$grid//.//$code//$year $hour_mean # drainage storage in mm per zone
$outpath//sifl//$grid//.//$code//$year $hour_mean # interflow storage in mm per zone
$outpath//sd__//$grid//.//$code//$year $hour_mean # saturation deficite per zone in mm
10    		     # Codes der Teilgebiete im Zonengrid
0.015		     # Rezessionsparameterter m fuer Saettigungsflaechenmodell in Metern
40.0  		     # Korrekturfaktor fuer Transmissivitaeten
8.0  		     # Korrekturfaktor fuer K-Wert (vertikale Versickerung), Modell erwartet k in m/s
6.0  		     # Speicherrueckgangskonstante Direktabflus ELS in h
0.0  		     # Saettigungsdefizit, bei dessen Unterschreitung lokaler Interflow gebildet wird
1.0  		     # Speicherrueckgangskonstante Interflow ELS in h
3600  		     # Rueckgangskonstante verzoegerter Basisabfluss in h
0.03 		     # maximale Tiefenversickerungsrate bei Saettigung in mm/h
0.01 		     # Anfangswert QBB
0.0  		     # Anfangsfuellung des SUZ-Speichers in n*nFK
0.45 		     # Anfangssaettigungsdefizit in n*nFK, beeinflusst den ersten Basisabfluss
3.0  		     # Anspringpunkt fuer Makroporenabfluss (in mm/h!, bezogen auf Stundenniederschlag!), alles darueber geht direkt in den Drainspeicher!
0.9  		     # Reduktionsfaktor fuer Auffuellung von Verdunstungsverlusten aus dem Grundwasser und aus dem Interflowspeicher
0.4  		     # Anteil an der effektiven Schneeschmelze, der bei geschlossener Schneedecke direkt abfliesst und nicht in den Boden gelangen kann
$readgrids               # 1=read grids from disk, else generate internal
$outpath//storage_topmodel.ftz    # if readgrids = 1, then this file contains the contents of the flow travel time zones for interflow and surface flow and for the tracers


[routing_model]
1                    # 0=ignore this module, 1 = run the module, 2=run the module with observed inflows into the routing channels (from discharge files)
$time                # duration of a time step in minutes
1 1200 90 24         # minimum/maximum specific discharge (l/s/km^2), number of log. fractions of the range, splitting of the timeintervall (24= 1 hour-intervalls are splitted into 24 Intervalls each of 2.5 min. duration)
$outpath//qgko//$grid//.//$code//$year $routing_code  # name of the statistic file with routed discharges
$inpath//spend_//$year//.dat                          # name of the file with observed discharges (mm/Timestep or m^3/s)
1     		 # number of following collumn descriptor
10 1   		 # if the first code would be a 7, then it would mean, that the modeled discharge of subbasin 1 (or lowest subbasin code) would communicate with the data column 7 in the specific discharge data file (date-columns are not counted!)
720                  #  timeoffset (for r-square calculation. intervals up to this parameter are not evaluated in r-square calculation. e.g. 12: first 12 intervals are neglected )


[abstraction_rule_reservoir_1]
0               # number of points, reading now as x-y-values0
1e4      1.0                                                 
1e5      1.0                                                 
1.0001e5 10.0                                                
1e6      10.0                                                
1.0001e6 50.0                                                
1e7      50.0                                                
1.0001e7 100.0                                               
1e8      100.0                                               
1.0001e8 500.0                                               


# the following section defines combinations of single landuse types to combinations of them.
# e.g. a landuse type deciduous forest may contain of oaks, bushes, and herbs, so each of those three components
# must be parameterised in the traditional landuse table. Example: oaks = code 1, bushes = code 2, herbs = code 3
# here, the combination of oaks, bushes and herbs will be parameterised like: 1 deciduous_forest { layers = 1, 2, 3;}
# The VCF (vegetation covered fraction) of each landuse will define the amount of water and radiation (except diffuse 
# radiation which will go through the canopy layer) reaching the next layer. The uppermost layer must be listed first, 
# the next layer follows then a.s.o.
# All multilayer-landuses must have an equal number of layers. Missing layers can be filled up from the end of the 
# list using landuse code 9999, e.g. grassland would be defined in a 3-layer configuration by "2 grass {layers = 4, 9999, 9999;}
# When the multilayer_landuse table is used, the codes of the LANDUSE-Grid are referring no longer to the landuse_table 
# anymore but to the multilayer_table following. The codes in the old landuse table are reffering to the entries in the 
# multilayer_landuse table

[multilayer_landuse] 
10 # count of multilayer landuses
1  water 		{ Landuse_Layers = 1, 1, 1; 	# references to the landuse table: the first land use code is assumed to be the uppermosts layer, the next one comes as scond a.s.o.
 		  	  k_extinct = 0.3; 		# extinction coefficient of d'Lambert-Beer's law for reducing radiation in its way through the canopies (after COUPmodel, Jansson and Karlberg)
 		  	  LAI_scale = 20;   		# Scaling factor for calculating the aerodynamic resistencies of layer 2..n dependent on the cumulated leaf area index (after COUPmodel, Jansson and Karlberg)
			}
2  settlements   	{ Landuse_Layers = 2, 2, 2;	k_extinct = 0.3; LAI_scale = 20;}
3  pine_forest 		{ Landuse_Layers = 3, 3, 3;	k_extinct = 0.3; LAI_scale = 20;}
4  decidous_forest  	{ Landuse_Layers = 4, 4, 4;	k_extinct = 0.3; LAI_scale = 20;}
5  mixed_forest  	{ Landuse_Layers = 5, 5, 5;	k_extinct = 0.3; LAI_scale = 20;}
6  agriculture     	{ Landuse_Layers = 6, 6, 6;	k_extinct = 0.3; LAI_scale = 20;}
7  grass_variable   	{ Landuse_Layers = 7, 7, 7;	k_extinct = 0.3; LAI_scale = 20;}
8  bushes  		{ Landuse_Layers = 8, 8, 8;	k_extinct = 0.3; LAI_scale = 20;}
15 rock    		{ Landuse_Layers = 15,15,15; 	k_extinct = 0.3; LAI_scale = 20;}
19 horticulture     	{ Landuse_Layers = 19,19,19; 	k_extinct = 0.3; LAI_scale = 20;}


[landuse_table]
10              # number of following land use codes
1 water     	{method          = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0; 		# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter. The count of days doesn't matter.
	        Albedo           = 0.05  0.05  0.05  0.05  0.05  0.05   0.05   0.05   0.05   0.05   0.05   0.05;  # Albedo (snow free)
	        rsc              = 20    20    20    20    20    20     20     20     20     20     20     20;    # leaf surface resistance in s/m
	        rs_interception	 = 20    20    20    20    20    20     20     20     20     20     20     20;    # INTERCEPTION surface resistance in s/m
	        LAI              = 1.0   1.0   1.0   1.0   1.0   1.0    1.0    1.0    1.0    1.0    1.0    1.0;   # Leaf Area Index (1/1)
	        Z0               = 0.01  0.01  0.01  0.01  0.01  0.01   0.01   0.01   0.01   0.01   0.01   0.01;  # Roughness length in m
	        VCF              = 0.1   0.1   0.1   0.1   0.1   0.1    0.1    0.1    0.1    0.1    0.1    0.1;   # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 0.01  0.01  0.01  0.01  0.01  0.01   0.01   0.01   0.01   0.01   0.01   0.01;  # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
2 settlements   {method    = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.2; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter. The count of days doesn't matter.
	        Albedo           = 0.1   0.1   0.1   0.1   0.1   0.1    0.1    0.1    0.1    0.1    0.1    0.1 ;  # Albedo (snow free)
	        rsc              = 100   100   100   100   100   100    100    100    100    100    100    100;   # leaf surface resistance in s/m
	        rs_interception	 = 100   100   100   100   100   100    100    100    100    100    100    100;   # INTERCEPTION surface resistance in s/m
	        LAI              = 1.0   1.0   1.0   1.0   1.0   1.0    1.0    1.0    1.0    1.0    1.0    1.0;   # Leaf Area Index (1/1)
	        Z0               = 10.0  10.0  10.0  10.0  10.0  10.0   10.0   10.0   10.0   10.0   10.0   10.0;  # Roughness length in m
	        VCF              = 0.5   0.5   0.5   0.5   0.5   0.5    0.5    0.5    0.5    0.5    0.5    0.5;   # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 0.2   0.2   0.2   0.2   0.2   0.2    0.2    0.2    0.2    0.2    0.2    0.2;   # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
3 pine_forest   {method    = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr    	 = 1.0;		# parameter for root density distribution
	        TReduWet     	 = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet 	 = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry     	 = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap 	 = 0.4; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays      	 = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo       	 = 0.12  0.12  0.12  0.12  0.12  0.12   0.12   0.12   0.12   0.12   0.12   0.12;  # Albedo (snow free)
	        rsc          	 = 80    80    75    65    55    55     55     55     55     75     80     80;    # leaf surface resistance in s/m
	        rs_interception	 = 80    80    75    65    55    55     55     55     55     75     80     80;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 210	 210   210	 210   210	 210	210	   210	  210	 210	210	   210;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI          	 = 8.0   8.0   8.0   9.0   12.0  12.0   12.0   12.0   11.0   10.0   8.0    8.0;   # Leaf Area Index (1/1)
	        Z0           	 = 10.0  10.0  10.0  10.0  10.0  10.0   10.0   10.0   10.0   10.0   10.0   10.0;  # Roughness length in m
	        VCF          	 = 0.9   0.9   0.9   0.9   0.9   0.9    0.9    0.9    0.9    0.9    0.9    0.9;   # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth    	 = 1.2   1.2   1.2   1.2   1.2   1.2    1.2    1.2    1.2    1.2    1.2    1.2;   # Root depth in m
	        AltDep       	 = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	             
4 decidous_forest  {method   = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
            	RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.3; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo           = 0.17  0.17  0.17  0.17  0.17  0.17   0.17   0.17   0.17   0.17   0.17   0.17;  # Albedo (snow free)
	        rsc              = 100   100   95    75    65    65     65     65     65     85     100    100;   # leaf surface resistance in s/m
	        rs_interception	 = 100   100   95    75    65    65     65     65     65     85     100    100;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 220	 220   220	 220   220	 220	220	   220	  220	 220	220	   220;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI              = 0.5   0.5   0.5   3     8     8      8      8      8      3      0.5    0.5;   # Leaf Area Index (1/1)
	        Z0               = 0.3   0.3   0.3   3.0   8.00  10.0   10.0   10.0   10.0   3.0    0.5    0.3;   # Roughness length in m
	        VCF              = 0.7   0.7   0.7   0.8   0.95  0.95   0.95   0.95   0.9    0.8    0.7    0.7;   # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 1.4   1.4   1.4   1.4   1.4   1.4    1.4    1.4    1.4    1.4    1.4    1.4;   # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
5 mixed_forest  {method      = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.35; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo           = 0.15  0.15  0.15  0.15  0.15  0.15   0.15   0.15   0.15   0.15   0.15   0.15;  # Albedo (snow free)
	        rsc              = 90    90    85    70    60    60     60     60     60     80     90     90;    # leaf surface resistance in s/m
	        rs_interception	 = 90    90    85    70    60    60     60     60     60     80     90     90;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 230	 230   230	 230   230	 230	230	   230	  230	 230	230	   230;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI              = 2     2     2     4     8     10     10     10     8      5      3      3;     # Leaf Area Index (1/1)
	        Z0               = 3.0   3.0   3.0   5.0   8.0   10.0   10.0   10.0   9.0    5.0    3.0    3.0;   # Roughness length in m
	        VCF              = 0.8   0.8   0.8   0.9   0.92  0.92   0.92   0.92   0.9    0.8    0.8    0.8;   # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 1.3   1.3   1.3   1.3   1.3   1.3    1.3    1.3    1.3    1.3    1.3    1.3;   # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
6 agriculture     {method    = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.3; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo           = 0.25  0.25  0.25  0.25  0.25  0.25   0.25   0.25   0.25   0.25   0.25   0.25;  # Albedo (snow free)
	        rsc              = 80    80    75    75    65    65     65     65     65     75     90     90;    # leaf surface resistance in s/m
	        rs_interception	 = 80    80    75    75    65    65     65     65     65     75     90     90;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 240	 240   240	 240   240	 240	240	   240	  240	 240	240	   240;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI              = 1     1     2     3     4     5      5      4      3      2      1      1;     # Leaf Area Index (1/1)
	        Z0               = 0.05  0.05  0.1   0.25  0.5   0.5    0.5    0.4    0.3    0.15   0.05   0.05;  # Roughness length in m
	        VCF              = 0.3   0.3   0.3   0.5   0.8   0.8    0.8    0.7    0.6    0.3    0.3    0.3 ;  # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 0.05  0.05  0.1   0.2   0.3   0.4    0.4    0.4    0.3    0.2    0.05   0.05;  # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
7 grass_variable   {method   = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.2; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo           = 0.25  0.25  0.25  0.25  0.25  0.25   0.25   0.25   0.25   0.25   0.25   0.25;  # Albedo (snow free)
	        rsc              = 90    90    75    65    50    55     55     55     60     70     90     90;    # leaf surface resistance in s/m
	        rs_interception	 = 90    90    75    65    50    55     55     55     60     70     90     90;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 250	 250   250	 250   250	 250	250	   250	  250	 250	250	   250;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI              = 2     2     2     2     3     4      4      4      4      2      2      2;     # Leaf Area Index (1/1)
	        Z0               = 0.15  0.15  0.15  0.15  0.3   0.4    0.36   0.33   0.3    0.15   0.15   0.15;  # Roughness length in m
	        VCF              = 0.95  0.95  0.95  0.95  0.95  0.95   0.95   0.95   0.95   0.95   0.95   0.95;  # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 0.4   0.4   0.4   0.4   0.4   0.4    0.4    0.4    0.4    0.4    0.4    0.4;   # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
8  bushes  	  {method           = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 0.5;  	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.35; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo           = 0.20  0.20  0.20  0.20  0.20  0.20   0.20   0.20   0.20   0.20   0.20   0.20;  # Albedo (snow free)
	        rsc              = 80    80    70    70    50    50     50     55     55     70     70     80;    # leaf surface resistance in s/m
	        rs_interception	 = 80    80    70    70    50    50     50     55     55     70     70     80;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 260	 260   260	 260   260	 260	260	   260	  260	 260	260	   260;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI              = 3.0   3.0   3.0   4.0   5.0   5.0    5.0    5.0    5.0    4.0    3.0    3.0;   # Leaf Area Index (1/1)
	        Z0               = 1.5   1.5   1.5   2.0   2.5   2.5    2.5    2.5    2.0    2.0    1.5    1.5;   # Roughness length in m
	        VCF              = 0.9   0.9   0.9   0.9   0.95  0.95   0.95   0.95   0.95   0.9    0.9    0.9;   # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 0.5   0.5   0.5   0.5   0.5   0.5    0.5    0.5    0.5    0.5    0.5    0.5;   # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
15 rock    	  {method           = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 0.5;  	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.1; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo           = 0.12  0.12  0.12  0.12  0.12  0.12   0.12   0.12   0.12   0.12   0.12   0.12;  # Albedo (snow free)
	        rsc              = 250   250   250   250   250   250    250    250    250    250    250    250;   # leaf surface resistance in s/m
	        rs_interception	 = 250   250   250   250   250   250    250    250    250    250    250    250;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 400	 400   400	 400   400	 400	400	   400	  400	 400	400	   400;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI              = 1.0   1.0   1.0   1.0   1.0   1.0    1.0    1.0    1.0    1.0    1.0    1.0;   # Leaf Area Index (1/1)
	        Z0               = 0.05  0.05  0.05  0.05  0.05  0.05   0.05   0.05   0.05   0.05   0.05   0.05;  # Roughness length in m
	        VCF              = 0.8   0.8   0.8   0.8   0.8   0.8    0.8    0.8    0.8    0.8    0.8    0.8;   # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 0.1   0.1   0.1   0.1   0.1   0.1    0.1    0.1    0.1    0.1    0.1    0.1;   # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	
19 horticulture    {method   = VariableDayCount; 					# valid methods: "VariableDayCount" with variable number of fix points (other methods will follow) --> old method: if the table is structured like the old ones, they are still valid
	        RootDistr        = 1.0;		# parameter for root density distribution
	        TReduWet         = 0.95;	# relative Theta value for beginning water stress (under wet conditions -> set >= 1 for crop which doesn't depend on an aeral zone
	        LimitReduWet     = 0.5;		# minimum relative reduction factor of real transpiration when water content reaches saturation. The reduction factor value will go down linearly starting at 1.0 when relative Theta equals TReduWet (e.g. 0.95) to LimitReduWet when the soil is saturated (Theta rel = 1.0)
	        HReduDry         = 3.45;	# hydraulic head (suction) for beginning dryness stress (for water content resulting in higher suctions, ETR will be reduced down to 0 at suction=150m)
	        IntercepCap      = 0.35; 	# optional: specific thickness of the water layer on the leafes in mm. if omitted here, the dedfault parameter from interception_model is used
	        JulDays          = 15    46    74    105   135   166    196    227    258    288    319    349 ;  # Julian days for all following rows. Each parameter must match the number of julian days given here! The count of days doesn't matter.
	        Albedo           = 0.25  0.25  0.25  0.25  0.25  0.25   0.25   0.25   0.25   0.25   0.25   0.25;  # Albedo (snow free)
	        rsc              = 100   100   90    70    60    60     60     60     60     80     100    100;   # leaf surface resistance in s/m
	        rs_interception	 = 100   100   90    70    60    60     60     60     60     80     100    100;    # INTERCEPTION surface resistance in s/m
	        rs_evaporation	 = 280	 280   280	 280   280	 280	280	   280	  280	 280	280	   280;    # SOIL surface resistance in s/m (for evaporation only)
	        LAI              = 0.5   0.5   0.5   2     4     5      5      5      4      3      0.5    0.5;   # Leaf Area Index (1/1)
	        Z0               = 0.4   0.40  0.40  1.00  2.5   3.0    3.0    3.0    3.0    1.0    0.4    0.4;   # Roughness length in m
	        VCF              = 0.75  0.75  0.75  0.75  0.75  0.75   0.75   0.75   0.75   0.75   0.75   0.75;  # Vegetation covered fraction ("Vegetationsbedeckungsgrad")
	        RootDepth        = 0.8   0.8   0.8   0.8   0.8   0.8    0.8    0.8    0.8    0.8    0.8    0.8;   # Root depth in m
	        AltDep           = 0.025 0.025 0.025 0.025 0.025 0.025 -0.025 -0.025 -0.025 -0.025 -0.025 -0.025; # Verschiebung des Juldays pro Meter (positiv: wird nach hinten geschoben, negativ: wird nach vorne geschoben -> Limit: Wenn zwei Punkte aufeinandertreffen, dann wird nicht weiter verschoben)
	        }	


#original landuse table up to WaSiM 6.4
#[landuse_table]
#9                  		# number of following land use codes, per row one use
#Co Landuse type     		albe- surface resistances rsc as monthly values         julian day for   LAI               (eff. veget. height) Veg.covering root depth [m]      Param. root   theta-value for beginning
#de     			do     1   2   3   4   5   6   7   8   9  10  11  12    the param.-sets  1   2   3   4     z01  2   3   4     1   2   3   4   1    2    3    4   distribution. etp-reduction
#-- --------------------------  ----- -----------------------------------------------  ----------------  -------------     ---------------   --------------- ------------------  ------------- ------------
 1  water           		0.05   20  20  20  20  20  20  20  20  20  20  20  20   110 150 250 280  1.  1.  1.  1.    .01 .01 .01 .01   .1  .1  .1  .1  0.01 0.01 0.01 0.01     1.0         3.45
 2  buildings_(settl_1)     	0.10  100 100 100 100 100 100 100 100 100 100 100 100   110 150 250 280  1.  1.  1.  1.    10. 10. 10. 10.   .3  .3  .3  .3  0.2  0.2  0.2  0.2      1.0         3.45
 3  surroundings_(settl_2)  	0.12  100 100 100 100 100 100 100 100 100 100 100 100   110 150 250 280  1.  1.5 1.5 1.     5.  5.  5.  5.   .5  .5  .5  .5  0.3  0.3  0.3  0.3      1.0         3.45
 4  forest_cat_1_(normal)	0.15   90  90  85  70  60  60  60  60  60  80  90  90   110 150 250 280  8. 12. 12.  8.     8. 10. 10.  8.   .95 .95 .95 .95 1.5  1.5  1.5  1.5      1.0         3.45
 5  forest_cat_2_(scattered)	0.15   90  90  85  70  60  60  60  60  60  80  90  90   110 150 250 280  6.  9.  9.  6.     6.  8.  8.  6.   .9  .9  .9  .9  1.3  1.3  1.3  1.0      1.0         3.45
 6  forest_cat_3_(very_scatt)	0.15   90  90  85  70  60  60  60  60  60  80  90  90   110 150 250 280  4.  6.  6.  4.     4.  6.  6.  4.   .85 .85 .85 .85 1.0  1.0  1.0  1.0      1.0         3.45
 8  grassland			0.25   90  90  75  65  50  55  55  55  60  70  90  90   110 150 250 280  2.  4.  4.  2.     0.3 0.4 0.4 0.3  .9  .9  .9  .9  0.4  0.4  0.4  0.4      1.0         3.45
 9  horticulture		0.25  100 100  90  70  60  60  60  60  60  80 100 100   110 150 250 280  1.  5.  5.  1.     0.4 3.0 3.0 0.4  .75 .75 .75 .75 0.8  0.8  0.8  0.8      1.0         3.45
15  fens			0.25   90  90  75  65  50  55  55  55  60  70  90  90   110 150 250 280  3.  4.  4.  3.     0.3 0.3 0.3 0.3  .8  .8  .8  .8  0.5  0.5  0.5  0.5      1.0         3.45
 


#[soil_table]
#14                  # number of following entries
#Code  name                       FC(Vol.%) mSB(Vol.%) ksat(m/s)  suction.  parameter     #k   theta-values                                               rel.k-values for the given thetas                              #h    theta-values for the following h-values                                              h-values for the left Thetas [m]                  #+thickns. maxratio      for each layer (downwards) one entry for k_sat [m/s] has to follow																										
#                                                                   [mm]   1=par 2=table                                                                                                                                                                                                                                                                              of layers	 ko_rel/ku_rel																																										
#---- ----------------           ----------  ---------  --------  -------- ------------- ----- ---------------------------------------------------------  ------------------------------------------------------------- -----  ---------------------------------------------------------------------------------   -------------------------------------------------  ---------  ------------- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
  1   Sand_(S)                        6.21     38.5     8.25E-5     385         2        10   .43 .4286 .3537 .2143 .1071 .0650 .0513 .0470 .0455 .0450  1 .9221 .2543 .0212 4.8E-04 7.1E-6 9.9E-8 1.3E-9 1.1E-11 0.0    14    0.43 .4286 .3537 .2143 .1071 .0650 .0513 .0470 .0455 .0452 .0450 .0450 .0450 .0450   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      8.16E-5 7.86E-5 7.38E-5 6.85E-5 6.36E-5 5.90E-5 5.48E-5 5.09E-5 4.72E-5 4.39E-5 4.07E-5 3.78E-5 3.51E-5 3.26E-5 3.03E-5 2.81E-5 2.61E-5 2.42E-5 2.25E-5 2.09E-5 1.94E-5		  
  2   loamy_sand_(LS)                10.91     37.3     4.05E-5     373         2        10   .43 .4282 .3740 .2736 .1661 .1043 .0767 .0651 .0600 .0570  1 .8651 .2679 .0422 .0022   7.3E-5 2.1E-6 5.6E-8 1.0E-09 0.0    14    0.43 .4282 .3740 .2736 .1661 .1043 .0767 .0651 .0600 .0583 .0573 .0571 .0570 .0570   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      4.01E-5 3.86E-5 3.62E-5 3.37E-5 3.12E-5 2.90E-5 2.69E-5 2.50E-5 2.32E-5 2.15E-5 2.00E-5 1.86E-5 1.72E-5 1.60E-5 1.49E-5 1.38E-5 1.28E-5 1.19E-5 1.10E-5 1.02E-5 9.52E-6
  3   sandy_loam_(SL)                12.28     34.5     1.23E-5     345         2        10   .41 .4088 .3871 .3431 .2659 .1878 .1339 .1026 .0841 .0657  1 .8097 .3595 .1269 .0207   1.7E-3 1.1E-4 6.0E-6 2.4E-07 0.0    14    0.41 .4088 .3871 .3431 .2659 .1878 .1339 .1026 .0841 .0753 .0690 .0668 .0660 .0657   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      1.21E-5 1.17E-5 1.10E-5 1.02E-5 9.47E-6 8.79E-6 8.16E-6 7.57E-6 7.03E-6 6.53E-6 6.06E-6 5.63E-6 5.22E-6 4.85E-6 4.50E-6 4.18E-6 3.88E-6 3.60E-6 3.34E-6 3.10E-6 2.88E-6
  4   silty_loam_(SIL)               22.58     38.3     1.25E-6     383         2        10   .45 .4496 .4458 .4392 .4239 .3936 .3469 .2928 .2373 .1039  1 .6382 .3764 .2441 .1251   4.5E-2 1.1E-2 1.9E-3 2.2E-04 0.0    14    0.45 .4496 .4458 .4392 .4239 .3936 .3469 .2928 .2373 .1966 .1513 .1249 .1106 .1039   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      1.24E-6 1.19E-6 1.12E-6 1.04E-6 9.64E-7 8.95E-7 8.31E-7 7.71E-7 7.16E-7 6.65E-7 6.17E-7 5.73E-7 5.32E-7 4.94E-7 4.58E-7 4.26E-7 3.95E-7 3.67E-7 3.41E-7 3.16E-7 2.93E-7
  5   loam_(L)                        12.9     35.2     2.89E-6     352         2        10   .43 .4293 .4217 .4074 .3754 .3223 .2608 .2071 .1633 .0884  1 .7131 .3875 .2154 .0811   1.8E-2 2.7E-3 3.0E-4 2.4E-05 0.0    14    0.43 .4293 .4217 .4074 .3754 .3223 .2608 .2071 .1633 .1361 .1101 .0972 .0910 .0884   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      2.86E-6 2.75E-6 2.58E-6 2.40E-6 2.23E-6 2.07E-6 1.92E-6 1.78E-6 1.65E-6 1.54E-6 1.43E-6 1.32E-6 1.23E-6 1.14E-6 1.06E-6 9.83E-7 9.13E-7 8.48E-7 7.87E-7 7.31E-7 6.78E-7
  6   sandy_clay_(SC)                19.43     28.0     3.33E-7     280         2        10   .38 .3794 .3758 .3706 .3606 .3437 .3206 .2943 .2656 .1704  1 .3191 .1423 .0797 .0357   1.2E-2 3.1E-3 6.6E-4 1.0E-04 0.0    14    0.38 .3794 .3758 .3706 .3606 .3437 .3206 .2943 .2656 .2422 .2117 .1906 .1772 .1704   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      3.30E-7 3.18E-7 2.98E-7 2.77E-7 2.57E-7 2.39E-7 2.21E-7 2.06E-7 1.91E-7 1.77E-7 1.65E-7 1.53E-7 1.42E-7 1.32E-7 1.22E-7 1.13E-7 1.05E-7 9.78E-8 9.08E-8 8.43E-8 7.83E-8
  7   silty_clay_(SIC)               27.65     29.0     5.56E-8     290         2        10   .36 .3599 .3596 .3591 .3581 .3562 .3526 .3465 .3363 .2665  1 .1439 .0803 .0569 .0369   2.1E-2 1.0E-2 4.2E-3 1.2E-03 0.0    14    0.36 .3599 .3596 .3591 .3581 .3562 .3526 .3465 .3363 .3245 .3042 .2865 .2737 .2665   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      5.49E-8 5.29E-8 4.97E-8 4.61E-8 4.28E-8 3.98E-8 3.69E-8 3.43E-8 3.18E-8 2.95E-8 2.74E-8 2.55E-8 2.36E-8 2.19E-8 2.04E-8 1.89E-8 1.76E-8 1.63E-8 1.51E-8 1.40E-8 1.30E-8
  8   clay_(C)                       29.12     31.2     5.56E-7     312         2        10   .38 .3799 .3792 .3784 .3767 .3735 .3679 .3592 .3461 .2707  1 .1244 .0641 .0429 .0258   1.3E-2 5.8E-3 2.0E-3 5.1E-04 0.0    14    0.38 .3799 .3792 .3784 .3767 .3735 .3679 .3592 .3461 .3324 .3101 .2915 .2782 .2707   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      5.49E-7 5.29E-7 4.97E-7 4.61E-7 4.28E-7 3.98E-7 3.69E-7 3.43E-7 3.18E-7 2.95E-7 2.74E-7 2.55E-7 2.36E-7 2.19E-7 2.04E-7 1.89E-7 1.76E-7 1.63E-7 1.51E-7 1.40E-7 1.30E-7
  9   moor_(M)                       47.31     75.0     8.25E-5     750         2        10   .80 .7995 .7965 .7920 .7821 .7617 .7248 .6694 .5937 .2868  1 .4269 .2497 .1733 .1049   5.2E-2 2.0E-2 5.8E-3 1.1E-03 0.0    14    0.80 .7995 .7965 .7920 .7821 .7617 .7248 .6694 .5937 .5231 .4248 .3545 .3099 .2868   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      8.16E-5 7.86E-5 7.38E-5 6.85E-5 6.36E-5 5.90E-5 5.48E-5 5.09E-5 4.72E-5 4.39E-5 4.07E-5 3.78E-5 3.51E-5 3.26E-5 3.03E-5 2.81E-5 2.61E-5 2.42E-5 2.25E-5 2.09E-5 1.94E-5
 10   settlements_rock_(R)           14.00     15.0     5.56E-8     150         2        10   .20 .1999 .1996 .1992 .1984 .1969 .1942 .1900 .1837 .1474  1 .1244 .0641 .0429 .0258   1.3E-2 5.8E-3 2.0E-3 5.1E-04 0.0    14    0.20 .1999 .1996 .1992 .1984 .1969 .1942 .1900 .1837 .1771 .1664 .1575 .1510 .1474   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      5.49E-8 5.29E-8 4.97E-8 4.61E-8 4.28E-8 3.98E-8 3.69E-8 3.43E-8 3.18E-8 2.95E-8 2.74E-8 2.55E-8 2.36E-8 2.19E-8 2.04E-8 1.89E-8 1.76E-8 1.63E-8 1.51E-8 1.40E-8 1.30E-8
 11   clay_loam_(CL)                 21.24     31.5     7.22E-7     315         2        10   .41 .4096 .4067 .4021 .3920 .3729 .3434 .3074 .2675 .1496  1 .5005 .2721 .1720 .0882   3.4E-2 9.3E-3 1.9E-3 2.7E-04 0.0    14    0.41 .4096 .4067 .4021 .3920 .3729 .3434 .3074 .2675 .2357 .1968 .1717 .1569 .1496   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      7.14E-7 6.88E-7 6.46E-7 6.00E-7 5.57E-7 5.17E-7 4.80E-7 4.46E-7 4.14E-7 3.84E-7 3.56E-7 3.31E-7 3.07E-7 2.85E-7 2.65E-7 2.46E-7 2.28E-7 2.12E-7 1.97E-7 1.83E-7 1.70E-7
 12   silt_(SI)                      28.17     42.6     6.94E-7     426         2        10   .46 .4596 .4565 .4511 .4386 .4129 .3702 .3157 .2549 .0901  1 .6139 .3711 .2503 .1384   5.7E-2 1.6E-2 3.3E-3 4.3E-04 0.0    14    0.46 .4596 .4565 .4511 .4386 .4129 .3702 .3157 .2549 .2075 .1519 .1181 .0991 .0901   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      6.87E-7 6.62E-7 6.21E-7 5.77E-7 5.35E-7 4.97E-7 4.61E-7 4.28E-7 3.98E-7 3.69E-7 3.43E-7 3.18E-7 2.95E-7 2.74E-7 2.55E-7 2.36E-7 2.19E-7 2.04E-7 1.89E-7 1.76E-7 1.63E-7
 13   silty_clay_loam_(SICL)         28.16     34.1     1.94E-7     341         2        10   .43 .4298 .4284 .4264 .4218 .4126 .3958 .3706 .3362 .1967  1 .4269 .2497 .1733 .1049   5.2E-2 2.0E-2 5.8E-3 1.1E-03 0.0    14    0.43 .4298 .4284 .4264 .4218 .4126 .3958 .3706 .3362 .3041 .2594 .2275 .2072 .1967   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      1.92E-7 1.85E-7 1.74E-7 1.61E-7 1.50E-7 1.39E-7 1.29E-7 1.20E-7 1.11E-7 1.03E-7 9.60E-8 8.91E-8 8.27E-8 7.68E-8 7.13E-8 6.62E-8 6.15E-8 5.71E-8 5.30E-8 4.92E-8 4.57E-8
 14   sandy_clay_loam_(SCL)          13.35     29.0     3.64E-6     290         2        10   .39 .3886 .3760 .3566 .3221 .2772 .2335 .1976 .1680 .1112  1 .5525 .2157 .0922 .0256   4.6E-3 6.4E-4 7.6E-5 6.7E-06 0.0    14    0.39 .3886 .3760 .3566 .3221 .2772 .2335 .1976 .1680 .1489 .1294 .1189 .1136 .1112   0 .01 .05 .1 .2 .4 .8 1.6 3.45 6.9 20 50 100 150   21 .3333       200      3.60E-6 3.47E-6 3.25E-6 3.02E-6 2.81E-6 2.60E-6 2.42E-6 2.24E-6 2.08E-6 1.93E-6 1.80E-6 1.67E-6 1.55E-6 1.44E-6 1.33E-6 1.24E-6 1.15E-6 1.07E-6 9.91E-7 9.20E-7 8.54E-7


#original soil table up to WaSiM 6.4
#[soil_table]
#14                  # number of following entries
#Code  name                       FC(Vol.%) mSB(Vol.%) ksat(m/s) suction. parameter   Theta_sat Theta_res alpha   n   layer thick maxratio      k-recession 
#                                                                   [mm]  1=par 2=tab   1/1        1/1     1/m               [m]  ko_rel/ku_rel per m ku/ko 
#---- ----------------           ----------  ---------  --------  ------- ----------- --------- --------- ----- ----- ----- ----- ------------- ----------- 
#  1   Sand_(S)                        6.21     38.5     8.25E-5     385         1        .43       .045   14.5   2.68   31  .3333      90           .4
#  2   loamy_sand_(LS)                10.91     37.3     4.05E-5     373         1        .43       .057   7.00   1.70   31  .3333      90           .4
#  3   sandy_loam_(SL)                12.28     34.5     1.23E-5     345         1        .41       .065   7.50   1.89   31  .3333      90           .4
#  4   silty_loam_(SIL)               22.58     38.3     1.25E-6     383         1        .45       .067   2.00   1.41   31  .3333      90           .4
#  5   loam_(L)                        12.9     35.2     2.89E-6     352         1        .43       .078   3.60   1.56   31  .3333      90           .4
#  6   sandy_clay_(SC)                19.43     28.0     3.33E-7     280         1        .38       .100   2.70   1.23   31  .3333      90           .4
#  7   silty_clay_(SIC)               27.65     29.0     5.56E-8     290         1        .36       .070   0.50   1.09   31  .3333      90           .4
#  8   clay_(C)                       29.12     31.2     5.56E-7     312         1        .38       .068   0.80   1.09   31  .3333      90           .4
#  9   moor_(M)                       47.31     75.0     8.25E-5     750         1        .80       .200   4.00   1.23   31  .3333      90           .4
# 10   settlements_rock_(R)           14.00     15.0     1.00E-9      50         1        .20       .040   8.00   1.80   31  .3333      90           .
# 11   clay_loam_(CL)                 21.24     31.5     7.22E-7     315         1        .41       .095   1.90   1.31   31  .3333      90           .4
# 12   silt_(SI)                      28.17     42.6     6.94E-7     426         1        .46       .034   1.60   1.37   31  .3333      90           .4
# 13   silty_clay_loam_(SICL)         28.16     34.1     1.94E-7     341         1        .43       .089   1.00   1.23   31  .3333      90           .4		
# 14   sandy_clay_loam_(SCL)          13.35     29.0     3.64E-6     290         1        .39       .010   5.90   1.48   31  .3333      90           .4		


[soil_table]
14
#co- name of the 
#de  soil profile
#-- ---------------
1 sand_(S)		{method = MultipleHorizons; 		
			 FCap = 6.21; mSB = 38.5; ksat_topmodel = 8.25E-5; suction = 385; # optional parameters which are needed for Topmodel only
			 PMacroThresh   = 1000;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
			 MacroCapacity  = 0   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
			 CapacityRedu   = 1.0 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
			 MacroDepth     = 0.0 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
			 Name		    = Sand1m  Sand2m  ;  # short descriptions
	       		 ksat      	    = 8.25e-5 6.25e-5 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.43    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.045   0.045   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 14.5    14.5    ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 2.68    2.68    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	      ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
2 loamy_sandsand_(S)		{method = MultipleHorizons; 		
				 FCap = 10.91; mSB = 37.3; ksat_topmodel = 4.05E-5; suction = 373; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 15  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 5   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.9 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 1.5 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = LS1m    LS2m    ;  # short descriptions
	       		 ksat      	    = 4.05E-5 3.05E-5 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.43    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.057   0.057   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 7.00    7.00    ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.70    1.70    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	  ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
3 sandy_loam_(SL) {method = MultipleHorizons; 		
				 FCap = 12.28; mSB = 34.5; ksat_topmodel = 1.23E-5; suction = 345; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 20  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 3   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.5 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 1.0 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = SL1m    SL2m    ;  # short descriptions
        		 ksat      	    = 1.23e-5 1.03e-5 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.41    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.065   0.065   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 7.50    7.50    ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.89    1.89    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	  ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
4 silty_loam_(SIL) {method = MultipleHorizons; 		
				 FCap = 22.58; mSB = 38.3; ksat_topmodel = 1.25E-6; suction = 383; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 10  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 4   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 1.0 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 2.0 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = SIL10m  SIL10m  ;  # short descriptions
        		 ksat      	    = 1.25e-6 0.95e-6 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.45    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.067   0.067   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 2.0     2.0     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.41    1.41    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	  ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
5 loam_(L) 		{method = MultipleHorizons; 		
				 FCap = 12.9; mSB = 35.2; ksat_topmodel = 2.89E-6; suction = 352; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 10  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 4   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 1.0 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 0.8 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = L10m    L10m    ;  # short descriptions
        		 ksat      	    = 2.89e-6 2.29e-6 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.43    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.078   0.078   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 3.6     3.6     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.56    1.56    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	  ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
6 sandy_clay_(SC) {method = MultipleHorizons; 		
				 FCap = 19.43; mSB = 28.0; ksat_topmodel = 3.33E-7; suction = 280; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 10  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 3   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.4 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 0.5 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = SC10m   SC10m   ;  # short descriptions
        		 ksat      	    = 3.33e-7 2.63e-7 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.38    0.30    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.1     0.1     ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 2.7     2.7     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.23    1.23    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	  ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
7 silty_clay_(SIC) {method = MultipleHorizons; 		
				 FCap = 27.65; mSB = 29.0; ksat_topmodel = 5.56E-8; suction = 290; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 8   ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 2   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.4 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 0.6 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = SIC10m  SIC10m  ;  # short descriptions
        		 ksat      	    = 5.56e-8 4.56e-8 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.36    0.30    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.07    0.07    ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 0.5     0.5     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.09    1.09    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	  ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
8 clay_(C) 		{method = MultipleHorizons; 		
				 FCap = 29.12; mSB = 31.2; ksat_topmodel = 5.56E-7; suction = 312; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 8   ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 3   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.5 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 0.7 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = C10m    C10m    ;  # short descriptions
        		 ksat      	    = 5.56e-8 4.56e-8 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.38    0.30    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.068   0.068   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 0.8     0.8     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.09    1.09    ;	 # van Genuchten Parameter n
		         Par_tau		= 0.5	  0.5	  ;  # sog. Mualem-Parameter tau in der van-Genuchten-Gleichung (dort normalerweise 0.5)
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
9 Moor_(M) 		{method = MultipleHorizons; 		
				 FCap = 47.31; mSB = 75.0; ksat_topmodel = 8.25E-5; suction = 750; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 38  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 12  ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.8 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 1.6 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = M10m    M10m    ;  # short descriptions
        		 ksat      	    = 8.e-4   6.e-4   ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.8     0.7     ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.2     0.2     ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 4.0     4.0     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.2     1.2     ;	 # van Genuchten Parameter n
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
10 Settlement_Rock_(R) {method = MultipleHorizons; 		
				 FCap = 14.00; mSB = 15.0; ksat_topmodel = 1E-9; suction = 50; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 10  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 1   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 1.0 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 2.0 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = R10m    R10m    ;  # short descriptions
        		 ksat      	    = 1.e-9   0.9e-9   ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.2     0.18     ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.04    0.04    ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 8.0     8.0     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.8     1.8     ;	 # van Genuchten Parameter n
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    = 1       30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
11 clay_loam_(CL) {method = MultipleHorizons; 		
				 FCap = 21.24; mSB = 31.5; ksat_topmodel = 7.22E-7; suction = 315; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 12  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 3   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.5 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 1.2 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = CL10m   CL10m   ;  # short descriptions
        		 ksat      	    = 7.22e-7 5.22e-7 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.41    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.095   0.095   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 1.9     1.9     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.31    1.31    ;	 # van Genuchten Parameter n
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    =  1      30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
12 silt_(SI)	{method = MultipleHorizons; 		
				 FCap = 28.17; mSB = 42.6; ksat_topmodel = 6.94E-7; suction = 426; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 15  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 4   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 1.0 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 1.5 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = SI10m   SI10m   ;  # short descriptions
        		 ksat      	    = 6.94e-7 5.94e-7 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.46    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.034   0.034   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 1.6     1.6     ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.37    1.37    ;	 # van Genuchten Parameter n
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    =  1      30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
13 silty_clay_(SICL) {method = MultipleHorizons; 		
				 FCap = 28.16; mSB = 34.1; ksat_topmodel = 1.94E-7; suction = 341; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 15  ;  # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 4   ;  # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 1.0 ;  # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 1.5 ;  # maximum depth of the macropores
		         horizon   	    = 1       2       ;  # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row
				 Name		    = SICL10m SICL10m ;  # short descriptions
        		 ksat      	    = 1.94e-7 1.44e-7 ;	 # saturated hydraulic conductivity	in m/s
	       		 k_recession    = 0.4     0.4     ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.43    0.40    ;	 # saturated water content (fillable porosity in 1/1)
		         theta_res 	    = 0.089   0.089   ;	 # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)
		         alpha     	    = 1.00    1.00    ;	 # van Genuchten Parameter Alpha
		         Par_n     	    = 1.23    1.23    ;	 # van Genuchten Parameter n
		         thickness 	    = 0.3333  0.3333  ;	 # thickness of each single numerical layer in this horizon in m
		         layers    	    =  1      30      ;	 # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }
14   profile_1	{method = MultipleHorizons; 		
				 FCap = 13.35; mSB = 29.0; ksat_topmodel = 3.64E-6; suction = 290; # optional parameters which are needed for Topmodel only
				 PMacroThresh   = 10  ; # precipitation capacity thresholding macropore runoff in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 MacroCapacity  = 5   ; # capacity of the macropores in mm per hour (not in m/s, because it's more convenient than to write it down in m/s, e.g. 5mm/h = 1.38e-6)
				 CapacityRedu   = 0.8 ; # reduction of the macropore capacity with depth -> pores become less dense. This Factor describes the reduction ratio per meter 
				 MacroDepth     = 1.0 ; # maximum depth of the macropores
		         horizon   	    = 1       2       3;	   # ID of the horizon (must be ascendent) it's recommended to name the horizons shortly in the following row   			
				 Name		    = Sand04m Clay01m Loam10m; # short descriptions
        		 ksat      	    = 4.0e-5  3.3e-7  3.0e-6;  # saturated hydraulic conductivity	in m/s                                                                                                                                                      		
	       		 k_recession    = 0.4     0.4     0.4   ;  # k sat recession with depth (could also be controlled by different layers if no k decrease is wanted (set this parameter to 1.0
		         theta_sat 	    = 0.43    0.38    0.40;	   # saturated water content (fillable porosity in 1/1)                                                                                                                                            	
		         theta_res 	    = 0.057   0.10    0.078;   # residual water content (in 1/1, water content which cannot be poured by transpiration, only by evaporation)                                                                                    
		         alpha     	    = 7.00    2.70    3.60;	   # van Genuchten Parameter Alpha                                                                                                                                                                 
		         Par_n     	    = 1.70    1.23    1.56;	   # van Genuchten Parameter n                                                                                                                                                                     
		         thickness 	    = 0.10    0.05    0.40;	   # thickness of each single numerical layer in this horizon in m                                                                                                                                 
		         layers    	    = 4       2       25;	   # numerical number of layers in this horizon. The thickness of the layer is given by layers x thickness. All profiles must have an identical number of layers (for memory handling reasons only)
		        }		        



# allowed keywords for substance transport (without ""-chars):
# "radioactive" resp. "non_radioactive"
# "evaporating" resp. "non_evaporating"
# "half_time" with its unit "d"
# "min_conc" and "max_conc"
# measures: "mg/l", "g/l", "kg/kg", "Kg/Kg"; all other units will be interpreted as kg/kg (relative concentration)


[substance_transport]
0    # number of tracers to be considered (max. 9)
#
# name  radioact. or not half time in days   evapor. or not  minim. concentr.  max.conc. with unit    initial        initial        output code           writecode             output path      output extension       output extension
#3chars                                                      if no: -9999      mg/l g/l kg/kg         conc. in soil  conc. in gr.w  statfiles             for grids             with closing "\" for stat-files         for grid files
#------ ---------------- ------------------- --------------- ----------------- ---------------------- -------------  -------------  --------------------- --------------------- ---------------- ---------------------- ----------------
  18O   non_radioactive  half_time = -9999 d     evaporating min_conc = -9999 max_conc = -9999 kg/kg  soilini = 1.0   gwini = 1.0   statcode = $hour_mean gridcode = $Writegrid path = $outpath  statext = $code//$year gridext = $suffix
  NACL  non_radioactive  half_time = -9999 d non_evaporating min_conc = 0     max_conc = 0.35  kg/kg  soilini = 0.01  gwini = 0.01  statcode = $hour_mean gridcode = $Writegrid path = $outpath  statext = $code//$year gridext = $suffix
  3H        radioactive  half_time =  4493 d     evaporating min_conc = 0     max_conc = 3500  kg/kg  soilini = 3.0   gwini = 3.0   statcode = $hour_mean gridcode = $Writegrid path = $outpath  statext = $code//$year gridext = $suffix


# irrigation descriptions
# method 1: count  MM1 DD1 amount1 MM2 DD2 amount2 MM3 DD3 amount3 MM4 DD4 amount4 MM5 DD5 amount5 MM6 DD6 amount6 MM7 DD7 amount7 MM8 DD8 amount8 MM9 DD9 amount9 MM10 DD10 amount10  
# method 2a: "starting from MM DD with XX mm to MM DD with YY mm every ZZ days" here, the start end end date are explicitly given 
# method 2b: "starting from MM DD with XX mm YY times every ZZ days" Here, the number of irrigation events is given explicitly */
# method 3: by demand: without additional parameters

[irrigation_table]
10                  # number of following irrigation codes, per row one use
#
#Code name         method     from        control by 
#                  (0=no irr, (1=GW         demand:     table:
#                  1=table,    2=river)     psi[m]                      [mm]            [mm]            [mm]            [mm]            [mm]            [mm]            [mm]            [mm]            [mm]              [mm]     
#                  2=demand)              start  stop   count  MM1 DD1 amount1 MM2 DD2 amount2 MM3 DD3 amount3 MM4 DD4 amount4 MM5 DD5 amount5 MM6 DD6 amount6 MM7 DD7 amount7 MM8 DD8 amount8 MM9 DD9 amount9 MM10 DD10 amount10  
#---- ------------ ---------- --------  --------------  ------ --------------- --------------- --------------- --------------- --------------- --------------- --------------- --------------- --------------- ------------------  
  1   water            2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
  2   settlements      2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
  3   pine_forest      2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
  4   decidous_forest  2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
  5   mixed_forest     2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
  6   agriculture      2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
  7   grass            2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
  8   bushes           2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
 15   rock             2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
 19   horticulture     2        1           3  0.3       5     5  15    80     6   1     80    6  15    80     7   1    80     7  15    80     8   1    80     8  15    80     9   1    80     9  15    80     10   15    80
